/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.rep.RAssoKey;
import com.ibm.hsc.rep.RAssoObject;
import com.ibm.hsc.rep.RAssoSchema;
import com.ibm.hsc.rep.RCimWrapper;
import com.ibm.hsc.rep.RClassSchema;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.RUtils;
import com.ibm.hsc.rep.serialization.RSerializableInterface;
import com.ibm.hsc.rep.serialization.RSerializableObject;
import com.ibm.hsc.rep.serialization.RSerializableProperty;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;

public class RObject
implements Cloneable,
RSerializableInterface {
    private int m_nsid;
    private RObjectId m_oid = null;
    private Object[] m_prop;
    private Vector[] m_link;
    private RClassSchema m_schema;

    public RObject() {
    }

    public RObject(String string, CIMInstance cIMInstance) throws CIMException {
        Vector vector = cIMInstance.getProperties();
        try {
            this.m_nsid = RUtils.getNameSpaceId(string);
            this.m_schema = RUtils.getClassSchema(this.m_nsid, RUtils.getClassId(this.m_nsid, cIMInstance.getClassName()));
            this.m_prop = new Object[this.m_schema.getNumOfProps()];
            this.m_link = new Vector[this.m_schema.getNumOfLinks()];
            for (int i = 0; i < vector.size(); ++i) {
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(i);
                RUtils.validateDataType(cIMProperty);
                Object object = RCimWrapper.getRValue(cIMProperty);
                this.setProperty(cIMProperty.getName(), object);
            }
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        if (vector.size() != this.m_schema.getNumOfProps()) {
            System.out.println("[TX-REP]the number of properties of this HSC repository object does not match what it is defined in the MOF");
            System.out.println("[TX-REP]size of props in repository = " + this.getSchema().getNumOfProps());
            System.out.println("[TX-REP]size of props in MOF = " + vector.size());
            System.out.println("[TX-REP]cimInst = " + cIMInstance);
            HSCCIMException hSCCIMException = new HSCCIMException("CIM_ERR_TYPE_MISMATCH");
            hSCCIMException.printStackTrace();
            throw hSCCIMException;
        }
    }

    public RObject(int n, int n2) throws RException {
        this.m_nsid = n;
        this.m_schema = RUtils.getClassSchema(n, n2);
        this.m_prop = new Object[this.m_schema.getNumOfProps()];
        this.m_link = new Vector[this.m_schema.getNumOfLinks()];
    }

    public RObject(int n, RClassSchema rClassSchema) {
        this.m_nsid = n;
        this.m_schema = rClassSchema;
        this.m_prop = new Object[this.m_schema.getNumOfProps()];
        this.m_link = new Vector[this.m_schema.getNumOfLinks()];
    }

    public RObject(RObjectId rObjectId) throws RException {
        this.m_nsid = rObjectId.getNameSpaceId();
        int n = rObjectId.getClassId();
        this.m_schema = RUtils.getClassSchema(this.m_nsid, n);
        this.m_prop = new Object[this.m_schema.getNumOfProps()];
        this.m_link = new Vector[this.m_schema.getNumOfLinks()];
        int n2 = rObjectId.getNumOfKeys();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.m_schema.getKeyPos(i);
            this.setProperty(n3, rObjectId.getKeyValue(i));
        }
    }

    public void loadObject(RSerializableObject rSerializableObject) throws ObjectStreamException {
        try {
            Vector vector = (Vector)rSerializableObject.getObject();
            int n = vector.size();
            this.m_nsid = RUtils.getNameSpaceId((String)vector.elementAt(0));
            int n2 = RUtils.getClassId(this.m_nsid, (String)vector.elementAt(1));
            this.m_schema = RUtils.getClassSchema(this.m_nsid, n2);
            this.m_prop = new Object[this.m_schema.getNumOfProps()];
            this.m_link = new Vector[this.m_schema.getNumOfLinks()];
            for (int i = 2; i < n; ++i) {
                RSerializableProperty rSerializableProperty = (RSerializableProperty)vector.elementAt(i);
                int n3 = this.m_schema.getIndex(rSerializableProperty.getName());
                this.m_prop[n3] = rSerializableProperty.getRValue();
            }
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new InvalidObjectException(rException.getID());
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        try {
            String string = "com.ibm.hsc.rep.client.RClientObject";
            Vector<Object> vector = new Vector<Object>();
            vector.add(RUtils.getNameSpaceString(this.m_nsid));
            vector.add(this.m_schema.getClassName());
            for (int i = 0; i < this.m_schema.getNumOfProps(); ++i) {
                RSerializableProperty rSerializableProperty = new RSerializableProperty(this.m_schema.isKey(i), this.m_schema.getPropName(i), this.m_prop[i]);
                vector.add(rSerializableProperty);
            }
            RSerializableObject rSerializableObject = new RSerializableObject(string, null, vector);
            return rSerializableObject;
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new InvalidObjectException(rException.getID());
        }
    }

    public Object clone() {
        Serializable serializable;
        int n;
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        RObject rObject = (RObject)object;
        rObject.m_prop = (Object[])this.m_prop.clone();
        for (n = 0; n < this.m_prop.length; ++n) {
            if (this.m_prop[n] == null) continue;
            if (this.m_prop[n] instanceof Vector) {
                rObject.m_prop[n] = ((Vector)this.m_prop[n]).clone();
                continue;
            }
            serializable = this.m_prop[n].getClass();
            if (!((Class)serializable).isArray()) continue;
            rObject.m_prop[n] = ((Object[])this.m_prop[n]).clone();
        }
        rObject.m_link = (Vector[])this.m_link.clone();
        for (n = 0; n < this.m_link.length; ++n) {
            if (this.m_link[n] == null) continue;
            rObject.m_link[n] = (Vector)this.m_link[n].clone();
            serializable = rObject.m_link[n];
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                RObjectId rObjectId = (RObjectId)((Vector)serializable).elementAt(i);
                ((Vector)serializable).setElementAt(rObjectId.clone(), i);
            }
        }
        return rObject;
    }

    public RClassSchema getSchema() {
        return this.m_schema;
    }

    public int getNameSpaceId() {
        return this.m_nsid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("instance of ");
        stringBuffer.append(this.m_schema.getClassName());
        stringBuffer.append(" {\n");
        int n = this.m_schema.getNumOfProps();
        for (int i = 0; i < n; ++i) {
            String string = this.m_schema.getPropName(i);
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            if (this.m_prop[i] instanceof Object[]) {
                Object[] objectArray = (Object[])this.m_prop[i];
                if (objectArray != null) {
                    Vector<Object> vector = new Vector<Object>();
                    for (int j = 0; j < objectArray.length; ++j) {
                        vector.add(objectArray[j]);
                    }
                    stringBuffer.append(vector);
                } else {
                    stringBuffer.append("null");
                }
            } else {
                stringBuffer.append(this.m_prop[i]);
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public int getClassId() {
        return this.m_schema.getClassId();
    }

    public boolean setProperty(int n, Object object) throws RException {
        if (n < this.m_schema.getNumOfProps() && n >= 0) {
            if (this.m_prop[n] == null && object == null) {
                return false;
            }
            if (this.m_prop[n] == null || object == null) {
                this.m_prop[n] = object;
                return true;
            }
            if (this.m_prop[n] instanceof Vector && object instanceof Vector) {
                if (!this.m_prop[n].equals(object)) {
                    this.m_prop[n] = object;
                    return true;
                }
            } else {
                if (this.m_prop[n] instanceof Vector || object instanceof Vector) {
                    System.out.println("[TX-REP] Warning in setProperty: data type inconsistency 1");
                    System.out.println("[TX-REP] new value: " + object + " old value: " + this.m_prop[n]);
                    this.m_prop[n] = object;
                    return true;
                }
                Class<?> clazz = this.m_prop[n].getClass();
                Class<?> clazz2 = object.getClass();
                if (clazz.isArray() && clazz2.isArray()) {
                    Object[] objectArray = (Object[])this.m_prop[n];
                    Object[] objectArray2 = (Object[])object;
                    boolean bl = false;
                    int n2 = objectArray.length;
                    if (n2 == objectArray2.length) {
                        bl = true;
                        for (int i = 0; i < n2; ++i) {
                            if (objectArray[i].equals(objectArray2[i])) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (!bl) {
                        System.out.println("[TX-REP] new value: " + object + " old value: " + this.m_prop[n]);
                        this.m_prop[n] = object;
                        return true;
                    }
                } else {
                    if (clazz.isArray() || clazz2.isArray()) {
                        System.out.println("[TX-REP] Warning in setProperty: data type inconsistency 2");
                        System.out.println("[TX-REP] new value: " + object + " old value: " + this.m_prop[n]);
                        this.m_prop[n] = object;
                        return true;
                    }
                    if (!this.m_prop[n].equals(object)) {
                        this.m_prop[n] = object;
                        return true;
                    }
                }
            }
            return false;
        }
        throw new RException("R_ERR_NOT_FOUND");
    }

    public Object getProperty(int n) throws RException {
        if (n < this.m_schema.getNumOfProps() && n >= 0) {
            return this.m_prop[n];
        }
        throw new RException("R_ERR_NOT_FOUND");
    }

    public boolean setProperty(String string, Object object) throws RException {
        int n = this.m_schema.getIndex(string);
        return this.setProperty(n, object);
    }

    public Object getProperty(String string) throws RException {
        return this.getProperty(this.m_schema.getIndex(string));
    }

    public RObjectId getObjectId() throws RException {
        if (this.m_oid == null) {
            this.m_oid = new RObjectId(this.m_nsid, this.m_schema.getClassId());
            for (int i = 0; i < this.m_schema.getNumOfKeys(); ++i) {
                Object object = this.getProperty(this.m_schema.getKeyPos(i));
                if (object == null) {
                    throw new RException("R_ERR_KEY_PROPERTY_NULL");
                }
                this.m_oid.setKeyValue(i, object);
            }
        }
        return this.m_oid;
    }

    public void setInstance() throws RException {
        RObjectId rObjectId = this.getObjectId();
        RObject rObject = (RObject)this.m_schema.getObjHash().get(rObjectId);
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        rObject.m_prop = this.m_prop;
    }

    public void addInstance() throws RException {
        RObjectId rObjectId = this.getObjectId();
        Hashtable hashtable = this.m_schema.getObjHash();
        RObject rObject = (RObject)hashtable.get(rObjectId);
        if (rObject != null) {
            throw new RException("R_ERR_ALREADY_EXISTS");
        }
        hashtable.put(rObjectId, this);
    }

    public void deleteInstance() throws RException {
        RObjectId rObjectId = this.getObjectId();
        RObject rObject = (RObject)this.m_schema.getObjHash().remove(rObjectId);
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        int n = this.m_schema.getLinkBase();
        int n2 = this.m_schema.getNumOfLinks();
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            int n4 = this.m_schema.getAssoId(n3);
            RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n4);
            if (rObject.m_link[i] == null) continue;
            for (int j = 0; j < rObject.m_link[i].size(); ++j) {
                RObjectId rObjectId2;
                RObjectId rObjectId3;
                int n5;
                RObjectId rObjectId4 = (RObjectId)rObject.m_link[i].elementAt(j);
                RObject rObject2 = rObjectId4.getObject();
                if (n3 == rAssoSchema.getRef1LinkId()) {
                    n5 = rAssoSchema.getRef2LinkId();
                    rObjectId3 = rObjectId;
                    rObjectId2 = rObjectId4;
                } else {
                    n5 = rAssoSchema.getRef1LinkId();
                    rObjectId3 = rObjectId4;
                    rObjectId2 = rObjectId;
                }
                if (rObject2 != null) {
                    System.out.println("[TX-REP]delete asso " + rAssoSchema.getClassName());
                    rObject2.removeLink(n5, rObjectId);
                }
                if (!rAssoSchema.hasProperty()) continue;
                RAssoKey rAssoKey = new RAssoKey(this.m_nsid, n4, rObjectId3, rObjectId2);
                Hashtable hashtable = rAssoSchema.getAssoPropHash();
                Hashtable hashtable2 = RAssoSchema.getAssoObjHash();
                hashtable2.remove(rAssoKey);
            }
        }
    }

    protected Vector enumLinks(int n) throws RException {
        RObjectId rObjectId = this.getObjectId();
        RObject rObject = (RObject)this.m_schema.getObjHash().get(rObjectId);
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        int n2 = this.m_schema.getLinkBase();
        int n3 = this.m_schema.getNumOfLinks();
        if (n < n2 || n >= n2 + n3) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        return rObject.m_link[n - n2];
    }

    public Vector associatorNames(int n) throws RException {
        int n2 = this.getLinkId(n);
        return this.associatorNamesByLink(n2);
    }

    public Vector associatorNamesByLink(int n) throws RException {
        Vector vector = this.enumLinks(n);
        if (vector != null) {
            vector = (Vector)vector.clone();
            for (int i = 0; i < vector.size(); ++i) {
                RObjectId rObjectId = (RObjectId)vector.elementAt(i);
                vector.setElementAt(rObjectId.clone(), i);
            }
        }
        return vector;
    }

    private int getLinkId(int n) throws RException {
        int n2;
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n);
        int n3 = rAssoSchema.getRef1ClassId();
        if (n3 == (n2 = rAssoSchema.getRef2ClassId())) {
            System.out.println("[TX-REP]Bug: RObject:getLinkId failed");
            System.out.println("[TX-REP]link ID for aid " + n + " is not unique.");
            throw new RException("R_ERR_FAILED");
        }
        int n4 = this.m_schema.getClassId();
        int n5 = -1;
        if (n4 == n3) {
            n5 = rAssoSchema.getRef1LinkId();
        } else if (n4 == n2) {
            n5 = rAssoSchema.getRef2LinkId();
        }
        if (n5 < 0) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        return n5;
    }

    public Vector associators(int n) throws RException {
        int n2 = this.getLinkId(n);
        return this.associatorsByLink(n2);
    }

    public Vector associatorsByLink(int n) throws RException {
        Vector vector = this.enumLinks(n);
        Vector<RObject> vector2 = null;
        if (vector != null) {
            vector2 = new Vector<RObject>();
            for (int i = 0; i < vector.size(); ++i) {
                RObjectId rObjectId = (RObjectId)vector.elementAt(i);
                RObject rObject = rObjectId.getObject();
                if (rObject == null) continue;
                vector2.add(rObject);
            }
        }
        return vector2;
    }

    public void addAssociation(int n, RObjectId rObjectId) throws RException {
        int n2 = this.getLinkId(n);
        RObject rObject = rObjectId.getObject();
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n);
        int n3 = rAssoSchema.getRef1ClassId();
        int n4 = rAssoSchema.getRef2ClassId();
        int n5 = -1;
        int n6 = this.m_schema.getClassId();
        if (n6 == n3) {
            n5 = n4;
        } else if (n6 == n4) {
            n5 = n3;
        } else {
            System.out.println("[TX-REP]the association cannot be applied to this object.");
            throw new RException("R_ERR_FAILED");
        }
        if (rObject.getSchema().getClassId() != n5) {
            System.out.println("[TX-REP]the object to be added in the association is a wrong type.");
            throw new RException("R_ERR_FAILED");
        }
        this.addLink(n2, rObjectId);
        int n7 = rObject.getLinkId(n);
        rObject.addLink(n7, this.getObjectId());
    }

    public void addAssociationByLink(int n, RObjectId rObjectId) throws RException {
        int n2 = this.m_schema.getAssoId(n);
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n2);
        int n3 = rAssoSchema.getRef1LinkId();
        int n4 = rAssoSchema.getRef2LinkId();
        int n5 = -1;
        if (n == n3) {
            n5 = n4;
        } else if (n == n4) {
            n5 = n3;
        } else {
            throw new RException("R_ERR_FAILED");
        }
        int n6 = rAssoSchema.getRef1ClassId();
        int n7 = rAssoSchema.getRef2ClassId();
        int n8 = -1;
        int n9 = this.m_schema.getClassId();
        if (n9 == n6) {
            n8 = n7;
        } else if (n9 == n7) {
            n8 = n6;
        } else {
            System.out.println("[TX-REP]the association cannot be applied to this object.");
            throw new RException("R_ERR_FAILED");
        }
        RObject rObject = rObjectId.getObject();
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        if (rObject.getSchema().getClassId() != n8) {
            System.out.println("[TX-REP]the object to be added in the association is a wrong type.");
            throw new RException("R_ERR_FAILED");
        }
        this.addLink(n, rObjectId);
        rObject.addLink(n5, this.getObjectId());
    }

    public void addAsso(int n, RObjectId rObjectId) throws RException {
        this.addAssociation(n, rObjectId);
    }

    public boolean hasAssociation(int n) throws RException {
        int n2 = this.getLinkId(n);
        return this.hasLink(n2);
    }

    public boolean hasAssociation(int n, RObjectId rObjectId) {
        try {
            return this.hasAssociation0(n, rObjectId);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("hasAssociation: Exp ignored");
            return false;
        }
    }

    public boolean hasAssociation0(int n, RObjectId rObjectId) throws RException {
        int n2 = this.getLinkId(n);
        RObject rObject = rObjectId.getObject();
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        boolean bl = this.hasLink(n2, rObjectId);
        int n3 = rObject.getLinkId(n);
        boolean bl2 = rObject.hasLink(n3, this.getObjectId());
        if (bl && bl2) {
            return true;
        }
        if (bl || bl2) {
            System.out.println("[TX-REP]Association lost one link");
            throw new RException("R_ERR_FAILED");
        }
        return false;
    }

    public boolean hasAssociationByLink(int n, RObjectId rObjectId) {
        try {
            return this.hasAssociationByLink0(n, rObjectId);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("hasAssociationByLink: Exp ignored");
            return false;
        }
    }

    public boolean hasAssociationByLink0(int n, RObjectId rObjectId) throws RException {
        RObject rObject;
        int n2 = this.m_schema.getAssoId(n);
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n2);
        int n3 = rAssoSchema.getRef1LinkId();
        int n4 = rAssoSchema.getRef2LinkId();
        int n5 = -1;
        if (n == n3) {
            n5 = n4;
        } else if (n == n4) {
            n5 = n3;
        } else {
            throw new RException("R_ERR_FAILED");
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.hasLink(n, rObjectId)) {
            bl = true;
        }
        if ((rObject = rObjectId.getObject()) == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        if (rObject.hasLink(n5, this.getObjectId())) {
            bl2 = true;
        }
        if (bl && bl2) {
            return true;
        }
        if (!bl && !bl2) {
            return false;
        }
        System.out.println("[TX-REP] Bug: missing link in association.");
        throw new RException("R_ERR_FAILED");
    }

    public void deleteAssociation(int n, RObjectId rObjectId) throws RException {
        int n2 = this.getLinkId(n);
        this.removeLink(n2, rObjectId);
        RObject rObject = rObjectId.getObject();
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        int n3 = rObject.getLinkId(n);
        rObject.removeLink(n3, this.getObjectId());
    }

    public void deleteAssociationByLink(int n, RObjectId rObjectId) throws RException {
        int n2 = this.m_schema.getAssoId(n);
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n2);
        int n3 = rAssoSchema.getRef1LinkId();
        int n4 = rAssoSchema.getRef2LinkId();
        int n5 = -1;
        if (n == n3) {
            n5 = n4;
        } else if (n == n4) {
            n5 = n3;
        } else {
            throw new RException("R_ERR_FAILED");
        }
        this.removeLink(n, rObjectId);
        RObject rObject = rObjectId.getObject();
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        rObject.removeLink(n5, this.getObjectId());
    }

    protected boolean hasLink(int n) throws RException {
        RObjectId rObjectId = this.getObjectId();
        RObject rObject = (RObject)this.m_schema.getObjHash().get(rObjectId);
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        int n2 = this.m_schema.getLinkBase();
        int n3 = this.m_schema.getNumOfLinks();
        if (n < n2 || n >= n2 + n3) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        return rObject.m_link[n - n2] != null && rObject.m_link[n - n2].size() > 0;
    }

    protected boolean hasLink(int n, RObjectId rObjectId) throws RException {
        RObjectId rObjectId2 = this.getObjectId();
        RObject rObject = (RObject)this.m_schema.getObjHash().get(rObjectId2);
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        int n2 = this.m_schema.getLinkBase();
        int n3 = this.m_schema.getNumOfLinks();
        if (n < n2 || n >= n2 + n3) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        return rObject.m_link[n - n2] != null && rObject.m_link[n - n2].contains(rObjectId);
    }

    protected void addLink(int n, RObjectId rObjectId) throws RException {
        RObjectId rObjectId2 = this.getObjectId();
        RObject rObject = (RObject)this.m_schema.getObjHash().get(rObjectId2);
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        int n2 = this.m_schema.getLinkBase();
        int n3 = this.m_schema.getNumOfLinks();
        if (n < n2 || n >= n2 + n3) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        if (rObject.m_link[n - n2] == null) {
            rObject.m_link[n - n2] = new Vector();
        } else if (rObject.m_link[n - n2].contains(rObjectId)) {
            throw new RException("R_ERR_ALREADY_EXISTS");
        }
        rObject.m_link[n - n2].add(rObjectId);
    }

    protected void removeLink(int n, RObjectId rObjectId) throws RException {
        RObjectId rObjectId2 = this.getObjectId();
        RObject rObject = (RObject)this.m_schema.getObjHash().get(rObjectId2);
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        int n2 = this.m_schema.getLinkBase();
        int n3 = this.m_schema.getNumOfLinks();
        if (n < n2 || n >= n2 + n3) {
            System.out.println("[TX-REP]linkId=" + n);
            System.out.println("[TX-REP]linkBase=" + n2);
            System.out.println("[TX-REP]numOfLinks=" + n3);
            throw new RException("R_ERR_NOT_FOUND");
        }
        if (rObject.m_link[n - n2] == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        if (!rObject.m_link[n - n2].contains(rObjectId)) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        rObject.m_link[n - n2].remove(rObjectId);
    }

    public CIMObjectPath cimGetCIMObjectPath(CIMOMHandle cIMOMHandle) throws CIMException {
        CIMObjectPath cIMObjectPath = null;
        try {
            String string = RUtils.getNameSpaceString(this.m_nsid);
            cIMObjectPath = new CIMObjectPath(this.m_schema.getClassName(), string);
            CIMClass cIMClass = ((ProviderCIMOMHandle)cIMOMHandle).getClass(cIMObjectPath, false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMObjectPath = new CIMObjectPath(this.m_schema.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath.setNameSpace(string);
            Vector vector = cIMObjectPath.getKeys();
            this.cimUpdateProperties(vector);
        }
        catch (RException rException) {
            System.out.println("[TX-REP]cimGetCIMObjectPath: class name=" + this.m_schema.getClassName());
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        return cIMObjectPath;
    }

    public CIMInstance cimGetInstance(CIMOMHandle cIMOMHandle) throws CIMException {
        CIMInstance cIMInstance = null;
        try {
            String string = RUtils.getNameSpaceString(this.m_nsid);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(this.m_schema.getClassName(), string);
            CIMClass cIMClass = cIMOMHandle.getClass(cIMObjectPath, false);
            cIMInstance = cIMClass.newInstance();
            Vector vector = cIMInstance.getProperties();
            this.cimUpdateProperties(vector);
        }
        catch (RException rException) {
            System.out.println("[TX-REP]cimGetInstance: class name=" + this.m_schema.getClassName());
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        return cIMInstance;
    }

    public void cimUpdateProperties(Vector vector) throws CIMException {
        try {
            for (int i = 0; i < vector.size(); ++i) {
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(i);
                String string = cIMProperty.getName();
                CIMDataType cIMDataType = cIMProperty.getType();
                Object object = this.getProperty(string);
                Object object2 = RCimWrapper.getCValue(cIMDataType, object, string);
                CIMValue cIMValue = null;
                if (object2 != null) {
                    cIMValue = new CIMValue(object2, cIMDataType);
                }
                cIMProperty.setValue(cIMValue);
            }
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
    }

    public void cimSetInstance(CIMOMHandle cIMOMHandle, CIMInstance cIMInstance) throws CIMException {
        Vector vector = cIMInstance.getProperties();
        try {
            for (int i = 0; i < vector.size(); ++i) {
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(i);
                RUtils.validateDataType(cIMProperty);
                Object object = RCimWrapper.getRValue(cIMProperty);
                this.setProperty(cIMProperty.getName(), object);
            }
        }
        catch (RException rException) {
            rException.printStackTrace();
            throw new HSCCIMException(rException.getID());
        }
        if (vector.size() != this.getSchema().getNumOfProps()) {
            System.out.println("[TX-REP]the number of properties of this HSC repository object does not match what it is defined in the MOF");
            System.out.println("[TX-REP]size of props in repository = " + this.getSchema().getNumOfProps());
            System.out.println("[TX-REP]size of props in MOF = " + vector.size());
            System.out.println("[TX-REP]cimInst = " + cIMInstance);
            HSCCIMException hSCCIMException = new HSCCIMException("CIM_ERR_TYPE_MISMATCH");
            hSCCIMException.printStackTrace();
            throw hSCCIMException;
        }
    }

    public Vector cimGetAssociatorNames(CIMOMHandle cIMOMHandle, int n) throws CIMException {
        int n2 = this.m_schema.getLinkedClassId(n);
        try {
            Vector vector = this.enumLinks(n);
            Vector<CIMObjectPath> vector2 = new Vector<CIMObjectPath>();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    RObjectId rObjectId = (RObjectId)vector.elementAt(i);
                    RObject rObject = rObjectId.getObject();
                    if (rObject == null) continue;
                    CIMObjectPath cIMObjectPath = rObject.cimGetCIMObjectPath(cIMOMHandle);
                    vector2.add(cIMObjectPath);
                }
            }
            return vector2;
        }
        catch (RException rException) {
            throw new HSCCIMException(rException.getID());
        }
    }

    public Vector cimGetAssociators(CIMOMHandle cIMOMHandle, int n) throws CIMException {
        int n2 = this.m_schema.getLinkedClassId(n);
        try {
            Vector vector = this.enumLinks(n);
            Vector<CIMInstance> vector2 = new Vector<CIMInstance>();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    RObjectId rObjectId = (RObjectId)vector.elementAt(i);
                    RObject rObject = rObjectId.getObject();
                    if (rObject == null) continue;
                    CIMInstance cIMInstance = rObject.cimGetInstance(cIMOMHandle);
                    vector2.add(cIMInstance);
                }
            }
            return vector2;
        }
        catch (RException rException) {
            throw new HSCCIMException(rException.getID());
        }
    }

    public Vector cimGetReferenceNames(CIMOMHandle cIMOMHandle, int n) throws CIMException {
        return this.cimRefs(cIMOMHandle, n, 0);
    }

    public Vector cimGetReferences(CIMOMHandle cIMOMHandle, int n) throws CIMException {
        return this.cimRefs(cIMOMHandle, n, 1);
    }

    private Vector cimRefs(CIMOMHandle cIMOMHandle, int n, int n2) throws CIMException {
        int n3 = this.m_schema.getLinkedClassId(n);
        try {
            String string = RUtils.getNameSpaceString(this.m_nsid);
            Vector vector = this.enumLinks(n);
            Vector<RAssoKey> vector2 = new Vector<RAssoKey>();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    RAssoKey rAssoKey;
                    RObjectId rObjectId = (RObjectId)vector.elementAt(i);
                    RObject rObject = rObjectId.getObject();
                    if (rObject == null) continue;
                    CIMObjectPath cIMObjectPath = rObject.cimGetCIMObjectPath(cIMOMHandle);
                    int n4 = this.m_schema.getAssoId(n);
                    RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n4);
                    String string2 = rAssoSchema.getClassName();
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string2, string);
                    CIMInstance cIMInstance = cIMOMHandle.getClass(cIMObjectPath2, false).newInstance();
                    String string3 = null;
                    String string4 = null;
                    if (n == rAssoSchema.getRef1LinkId()) {
                        string4 = rAssoSchema.getRef1PropName();
                        string3 = rAssoSchema.getRef2PropName();
                    } else if (n == rAssoSchema.getRef2LinkId()) {
                        string4 = rAssoSchema.getRef2PropName();
                        string3 = rAssoSchema.getRef1PropName();
                    } else {
                        throw new HSCCIMException("Association Error");
                    }
                    cIMInstance.setProperty(string3, new CIMValue((Object)cIMObjectPath));
                    CIMObjectPath cIMObjectPath3 = this.cimGetCIMObjectPath(cIMOMHandle);
                    cIMInstance.setProperty(string4, new CIMValue((Object)cIMObjectPath3));
                    if (rAssoSchema.hasProperty()) {
                        rAssoKey = new RAssoKey(this.m_nsid, n4);
                        if (n == rAssoSchema.getRef1LinkId()) {
                            rAssoKey.setRef1ObjectId(this.getObjectId());
                            rAssoKey.setRef2ObjectId(rObjectId);
                        } else if (n == rAssoSchema.getRef2LinkId()) {
                            rAssoKey.setRef1ObjectId(rObjectId);
                            rAssoKey.setRef2ObjectId(this.getObjectId());
                        } else {
                            System.out.println("[TX-REP]It must be a bug. An association with one or more regular properties might not be defined well. ");
                            throw new HSCCIMException("CIM_ERR_FAILED");
                        }
                        Hashtable hashtable = rAssoSchema.getAssoPropHash();
                        Hashtable hashtable2 = RAssoSchema.getAssoObjHash();
                        Hashtable hashtable3 = (Hashtable)hashtable2.get(rAssoKey);
                        Enumeration enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            String string5 = (String)enumeration.nextElement();
                            CIMDataType cIMDataType = (CIMDataType)hashtable.get(string5);
                            Object var27_28 = null;
                            if (hashtable3 != null) {
                                var27_28 = hashtable3.get(string5);
                            }
                            Object object = RCimWrapper.getCValue(cIMDataType, var27_28, string5);
                            CIMValue cIMValue = null;
                            if (object != null) {
                                cIMValue = new CIMValue(object, cIMDataType);
                            }
                            cIMInstance.setProperty(string5, cIMValue);
                        }
                    }
                    rAssoKey = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                    rAssoKey.setNameSpace(string);
                    if (n2 == 0) {
                        vector2.add(rAssoKey);
                        continue;
                    }
                    vector2.add((RAssoKey)cIMInstance);
                }
            }
            return vector2;
        }
        catch (RException rException) {
            throw new HSCCIMException(rException.getID());
        }
    }

    public Vector referencesByLink(int n) throws RException {
        int n2 = this.m_schema.getAssoId(n);
        int n3 = this.m_schema.getLinkedClassId(n);
        String string = RUtils.getNameSpaceString(this.m_nsid);
        Vector vector = this.enumLinks(n);
        Vector<RAssoObject> vector2 = new Vector<RAssoObject>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                RObjectId rObjectId = (RObjectId)vector.elementAt(i);
                RObject rObject = rObjectId.getObject();
                if (rObject == null) continue;
                RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n2);
                String string2 = rAssoSchema.getClassName();
                RAssoKey rAssoKey = new RAssoKey(this.m_nsid, n2);
                if (rObjectId.getClassId() == rAssoSchema.getRef1ClassId()) {
                    rAssoKey.setRef1ObjectId(rObjectId);
                    rAssoKey.setRef2ObjectId(this.getObjectId());
                } else if (rObjectId.getClassId() == rAssoSchema.getRef2ClassId()) {
                    rAssoKey.setRef1ObjectId(this.getObjectId());
                    rAssoKey.setRef2ObjectId(rObjectId);
                } else {
                    throw new RException("Association Error");
                }
                RAssoObject rAssoObject = new RAssoObject(rAssoKey);
                if (rAssoSchema.hasProperty()) {
                    Hashtable hashtable = rAssoSchema.getAssoPropHash();
                    Hashtable hashtable2 = RAssoSchema.getAssoObjHash();
                    Hashtable hashtable3 = (Hashtable)hashtable2.get(rAssoKey);
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        CIMDataType cIMDataType = (CIMDataType)hashtable.get(string3);
                        Object var20_20 = null;
                        if (hashtable3 != null) {
                            var20_20 = hashtable3.get(string3);
                        }
                        rAssoObject.setProperty(string3, var20_20);
                    }
                }
                vector2.add(rAssoObject);
            }
        }
        return vector2;
    }

    public Vector deleteAssociated(int n) throws RException {
        Vector vector = this.associatorNames(n);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                RObjectId rObjectId = (RObjectId)enumeration.nextElement();
                RObject rObject = rObjectId.getObject();
                if (rObject == null) continue;
                rObject.deleteInstance();
            }
        }
        return vector;
    }

    public Vector deleteAssociatedByLink(int n) throws RException {
        Vector vector = this.associatorNamesByLink(n);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                RObjectId rObjectId = (RObjectId)enumeration.nextElement();
                RObject rObject = rObjectId.getObject();
                if (rObject == null) continue;
                rObject.deleteInstance();
            }
        }
        return vector;
    }

    public void deleteAssociations(int n) throws RException {
        RObjectId rObjectId = this.getObjectId();
        RObject rObject = (RObject)this.m_schema.getObjHash().get(rObjectId);
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        int n2 = this.getLinkId(n);
        int n3 = this.m_schema.getLinkBase();
        int n4 = this.m_schema.getNumOfLinks();
        if (n2 < n3 || n2 >= n3 + n4) {
            System.out.println("[TX-REP]linkId=" + n2);
            System.out.println("[TX-REP]linkBase=" + n3);
            System.out.println("[TX-REP]numOfLinks=" + n4);
            throw new RException("R_ERR_NOT_FOUND");
        }
        Vector vector = rObject.m_link[n2 - n3];
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                RObjectId rObjectId2 = (RObjectId)iterator.next();
                RObject rObject2 = rObjectId2.getObject();
                if (rObject2 != null) {
                    int n5 = rObject2.getLinkId(n);
                    rObject2.removeLink(n5, rObjectId);
                }
                iterator.remove();
            }
        }
    }

    public void deleteAssociationsByLink(int n) throws RException {
        RObjectId rObjectId = this.getObjectId();
        RObject rObject = (RObject)this.m_schema.getObjHash().get(rObjectId);
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        int n2 = this.m_schema.getAssoId(n);
        RAssoSchema rAssoSchema = RUtils.getAssoSchema(this.m_nsid, n2);
        int n3 = rAssoSchema.getRef1LinkId();
        int n4 = rAssoSchema.getRef2LinkId();
        int n5 = -1;
        if (n == n3) {
            n5 = n4;
        } else if (n == n4) {
            n5 = n3;
        } else {
            throw new RException("R_ERR_FAILED");
        }
        int n6 = this.m_schema.getLinkBase();
        int n7 = this.m_schema.getNumOfLinks();
        if (n < n6 || n >= n6 + n7) {
            System.out.println("[TX-REP]linkId=" + n);
            System.out.println("[TX-REP]linkBase=" + n6);
            System.out.println("[TX-REP]numOfLinks=" + n7);
            throw new RException("R_ERR_NOT_FOUND");
        }
        Vector vector = rObject.m_link[n - n6];
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                RObjectId rObjectId2 = (RObjectId)iterator.next();
                RObject rObject2 = rObjectId2.getObject();
                if (rObject2 != null) {
                    rObject2.removeLink(n5, rObjectId);
                }
                iterator.remove();
            }
        }
    }

    public void traverse(HashSet hashSet) throws RException {
        RObjectId rObjectId = this.getObjectId();
        RObject rObject = (RObject)this.m_schema.getObjHash().get(rObjectId);
        if (rObject == null) {
            throw new RException("R_ERR_NOT_FOUND");
        }
        hashSet.add(rObjectId);
        System.out.println("TRAVERSE { " + rObjectId);
        if (rObject.m_link != null) {
            for (int i = 0; i < rObject.m_link.length; ++i) {
                Vector vector = rObject.m_link[i];
                if (vector == null) continue;
                for (int j = 0; j < vector.size(); ++j) {
                    RObjectId rObjectId2 = (RObjectId)vector.elementAt(j);
                    RObject rObject2 = rObjectId2.getObject();
                    if (hashSet.contains(rObjectId2)) continue;
                    rObject2.traverse(hashSet);
                }
            }
        }
        System.out.println("}");
    }

    public void deleteBranch() throws RException {
        HashSet hashSet = new HashSet();
        this.traverse(hashSet);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            RObjectId rObjectId = (RObjectId)iterator.next();
            RObject rObject = rObjectId.getObject();
            System.out.println("====Deleting: " + rObjectId);
            rObject.deleteInstance();
        }
    }
}

